package gov.va.med.mhv.common.api.dto;

import java.io.Serializable;
import java.util.Date;

public class InPersonAuthenticationDTOLight implements Serializable {

	private static final long serialVersionUID = 7783638251724037972L;

	private Long id;
	private Integer oplock;
	private Date authenticationDate;
	private Date startUpgradeOnlineDateTime;
	private String authenticatedBy;
	private String status;
	private Date signedFormOnlineDateTime;
	private Boolean participationFormSigned;
	private String defermentReason;
	private String removalReason;
	private Boolean identificationPresented;
	private Boolean videoViewed;
	private String mviAuthenticationStatus;
	private Boolean approvedForRecordsAccess;
	private Date startUpgradeManualDateTime;
	private Long patientId;
	private FacilityInfoDTO authenticatingFacilityDTO;

	public InPersonAuthenticationDTOLight(InPersonAuthenticationDTO ipaDTO) {
		this.setId(ipaDTO.getId());
		this.setOplock(ipaDTO.getOplock());
		this.setAuthenticationDate(ipaDTO.getAuthenticationDate());
		this.setStartUpgradeOnlineDateTime(ipaDTO.getAuthenticationDate());
		this.setAuthenticatedBy(ipaDTO.getAuthenticatedBy());
		this.setStatus(ipaDTO.getStatus());
		this.setSignedFormOnlineDateTime(ipaDTO.getSignedFormOnlineDateTime());
		this.setParticipationFormSigned(ipaDTO.getParticipationFormSigned());
		this.setDefermentReason(ipaDTO.getDefermentReason());
		this.setRemovalReason(ipaDTO.getRemovalReason());
		this.setIdentificationPresented(ipaDTO.getIdentificationPresented());
		this.setVideoViewed(ipaDTO.getVideoViewed());
		this.setMviAuthenticationStatus(ipaDTO.getMviAuthenticationStatus());
		this.setApprovedForRecordsAccess(ipaDTO.getApprovedForRecordsAccess());
		this.setStartUpgradeManualDateTime(ipaDTO.getStartUpgradeManualDateTime());
		if(ipaDTO.getPatient() != null) {
			this.setPatientId(ipaDTO.getPatient().getId());
		}
		this.setAuthenticatingFacilityDTO(ipaDTO.getAuthenticatingFacilityDTO());
	}
	
	public InPersonAuthenticationDTOLight() {
		
	}
	
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Date getAuthenticationDate() {
		return authenticationDate;
	}

	public void setAuthenticationDate(Date authenticationDate) {
		this.authenticationDate = authenticationDate;
	}

	public Date getStartUpgradeOnlineDateTime() {
		return startUpgradeOnlineDateTime;
	}

	public void setStartUpgradeOnlineDateTime(Date startUpgradeOnlineDateTime) {
		this.startUpgradeOnlineDateTime = startUpgradeOnlineDateTime;
	}

	public String getAuthenticatedBy() {
		return authenticatedBy;
	}

	public void setAuthenticatedBy(String authenticatedBy) {
		this.authenticatedBy = authenticatedBy;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public Date getSignedFormOnlineDateTime() {
		return signedFormOnlineDateTime;
	}

	public void setSignedFormOnlineDateTime(Date signedFormOnlineDateTime) {
		this.signedFormOnlineDateTime = signedFormOnlineDateTime;
	}

	public Boolean getParticipationFormSigned() {
		return participationFormSigned;
	}

	public void setParticipationFormSigned(Boolean participationFormSigned) {
		this.participationFormSigned = participationFormSigned;
	}

	public String getDefermentReason() {
		return defermentReason;
	}

	public void setDefermentReason(String defermentReason) {
		this.defermentReason = defermentReason;
	}

	public String getRemovalReason() {
		return removalReason;
	}

	public void setRemovalReason(String removalReason) {
		this.removalReason = removalReason;
	}

	public Boolean getIdentificationPresented() {
		return identificationPresented;
	}

	public void setIdentificationPresented(Boolean identificationPresented) {
		this.identificationPresented = identificationPresented;
	}

	public Boolean getVideoViewed() {
		return videoViewed;
	}

	public void setVideoViewed(Boolean videoViewed) {
		this.videoViewed = videoViewed;
	}

	public String getMviAuthenticationStatus() {
		return mviAuthenticationStatus;
	}

	public void setMviAuthenticationStatus(String mviAuthenticationStatus) {
		this.mviAuthenticationStatus = mviAuthenticationStatus;
	}

	public Boolean getApprovedForRecordsAccess() {
		return approvedForRecordsAccess;
	}

	public void setApprovedForRecordsAccess(Boolean approvedForRecordsAccess) {
		this.approvedForRecordsAccess = approvedForRecordsAccess;
	}

	public Date getStartUpgradeManualDateTime() {
		return startUpgradeManualDateTime;
	}

	public void setStartUpgradeManualDateTime(Date startUpgradeManualDateTime) {
		this.startUpgradeManualDateTime = startUpgradeManualDateTime;
	}

	public FacilityInfoDTO getAuthenticatingFacilityDTO() {
		return authenticatingFacilityDTO;
	}

	public void setAuthenticatingFacilityDTO(FacilityInfoDTO authenticatingFacilityDTO) {
		this.authenticatingFacilityDTO = authenticatingFacilityDTO;
	}

	public Long getPatientId() {
		return patientId;
	}

	public void setPatientId(Long patientId) {
		this.patientId = patientId;
	}
}
